%def_without test
%define module_version 1.01
%define module_name MySQL-TableInfo
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: Perl extension for getting access into mysql's column information.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHERZODR/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
MySQL::TableInfo is a handy class for getting easy access to MySQL tables' descriptions
which is available via

    DESCRIBE table_name, SHOW COLUMNS FROM table_name

queries. It's also handy for constructing form based CGI applications to control HTML forms'
attributes such as `VALUE', `SIZE', `MAXLENGTH', `TYPE' and so forth.
For example, if you have a ENUM('Yes', 'No') column in your mysql table, then you normally
would present it either as a group of radio buttons, or as a <SELECT> menu. If you modify
the column, and add one more option, ENUM('Yes', 'No', 'N/A'), then you will have to
re-write your html code accordingly. By using MySQL::TableInfo, you can avoide this double
troubles. Consider the following code:

    use CGI;
    use DBI;
    use MySQL::TableInfo;

    my $CGI = new CGI:
    my $dbh = DBI->connect(....);
    my $table = new MySQL::TableInfo($dbh, "bio");

    print $CGI->header, $CGI->start_html("MySQL::TableInfo");

    print $CGI->start_form,
        $CGI->div("Do you wear beard?"),
        $CGI->checkbox_group( -name=>'has_beard',
                              -values=>[$table->set('has_beard')],
                              -default=>$table->default('has_beard')),
    $CGI->end_form;

    print $CGI->end_html;

As you see, modifying 'has_beard' column, which is an enumeration column, whould
reflect in your CGI too.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/M*

%changelog
