# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Text/CSV.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Nagios-Object
%define upstream_version 0.21.20

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Perl objects to represent Nagios configuration
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Nagios/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(List/Compare.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/NoWarnings.pm)
BuildRequires: perl(Module/Build.pm)
BuildArch: noarch
Source44: import.info

%description
This module contains the code for creating perl objects to represent any of
the Nagios objects. All of the perl classes are auto-generated at
compile-time, so it's pretty trivial to add new attributes or even entire
objects. 

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL installdirs=vendor

./Build

%check
./Build test

%install
./Build install destdir=%{buildroot}

%files
%doc META.yml ChangeLog README
%perl_vendor_privlib/*
/usr/bin/config_status_demo.pl
/usr/bin/decode_flags.pl
/usr/bin/parse.pl
/usr/bin/statusdat_demo.pl
/usr/bin/test_configuration.pl
%{_mandir}/man1/config_status_demo.pl.1*
%{_mandir}/man1/decode_flags.pl.1*
%{_mandir}/man1/parse.pl.1*
%{_mandir}/man1/statusdat_demo.pl.1*
%{_mandir}/man1/test_configuration.pl.1*



%changelog
