# BEGIN SourceDeps(oneline):
BuildRequires: libadns-devel perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XSLoader.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Net-ADNS
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt7
Summary: Perl wrapper for the Asynchronous DNS client library
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SA/SALVA/%module_name-%module_version.tar.gz

%description
From the adns library web site:

  ADNS: Advanced, easy to use, asynchronous-capable DNS client library
  and utilities.

  In contrast with the standard interfaces, gethostbyname et al and
  libresolv, it has the following features:

    - It is reasonably easy to use for simple programs which just want
      to translate names to addresses, look up MX records, etc.

    - It can be used in an asynchronous, non-blocking, manner. Many
      queries can be handled simultaneously.

    - Responses are decoded automatically into a natural
      representation - there is no need to deal with DNS packet
      formats.

    - Sanity checking (eg, name syntax checking, reverse/forward
      correspondence, CNAME pointing to CNAME) is performed
      automatically.

    - Time-to-live, CNAME and other similar information is returned in
      an easy-to-use form, without getting in the way.

    - There is no global state in the library; resolver state is an
      opaque data structure which the client creates explicitly. A
      program can have several instances of the resolver.

    - Errors are reported to the application in a way that
      distinguishes the various causes of failure properly.

    - Understands conventional resolv.conf, but this can overridden by
      environment variables.

    - Flexibility. For example, the application can tell adns to:
      ignore environment variables (for setuid programs), disable
      hostname syntax sanity checks to return arbitrary data, override
      or ignore resolv.conf in favour of supplied configuration, etc.

    - Believed to be correct! For example, will correctly back off to
      TCP in case of long replies or queries, or to other nameservers if
      several are available. It has sensible handling of bad responses
      etc.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/N*
%perl_vendor_autolib/*

%changelog
