# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache2/Const.pm) perl(Devel/Confess.pm) perl(ExtUtils/MakeMaker.pm) perl(Net/API/REST.pm) perl(Net/API/Stripe.pm) perl(Nice/Try.pm) perl(Test/Mock/Apache2.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(constant.pm) perl(parent.pm) perl(strict.pm)
# END SourceDeps(oneline)
%define module_name Net-API-Stripe-WebHook-Apache
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.100.2
Release: alt1
Summary: A Stripe WebHook Implementation using Apache
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JD/JDEGUEST/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This is the module to handle Stripe Web Hooks using Apache/mod_perl configuration

The way this works is you create your own module which inherits from this one. You override the init method in which you create the object property *event_handler* with an hash value with keys corresponding to the types of Stripe events. A dot in the Stripe event type corresponds to a sub hash in our *event_handler* definition.

You can set up your endpoint on Stripe dashboard at: https://dashboard.stripe.com/webhooks or do it via the api with the section on "webhook" in the Net::API::Stripe manpage.

See also the list of all possible Stripe endpoints

For example:

    sub init
    {
        my $self = shift( @_ );
        $self->SUPER::init( @_ );
        $self->{event_handler} = 
        {
        account =>
            {
                updated => $self->curry::account_updated,
                application => 
                {
                    authorized => $self->curry:account_application_authorised,
                },
            },
        charge => 
            {
                captured => $self->curry::charge_captured,
                dispute =>
                {
                    created => $self->curry::charge_dispute_created,
                }
            },
        customer =>
            {
                created => $self->curry::customer_created,
            },
        # A fallback method for all other event types not purposely defined here
        fallback => $self->curry::fallback,
        ## And so on....
        };
    }

Nota bene: here in this example above, I use the curry manpage which is a very handy module.

In a nutshell: when an http query is made by Stripe on your webhook, Apache will trigger the method handler, which will check and create the object environment, and call the method event_handler provided by this package to find out the sub in charge of this Stripe event type, as defined in your map *event_handlers*. Your own method is then called and you can do whatever you want with Strip...

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE README Changes
%perl_vendor_privlib/N*

%changelog
