%define module_name Net-Address-IP-Cipher
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/Cipher/AES.pm) perl(Crypt/KeyDerivation.pm) perl(ExtUtils/MakeMaker.pm) perl(Net/IP.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.6
Release: alt1
Summary: IPv6 / IPv4 address encryption to a valid address, for pseudo anonymization.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/H/HU/HUGUEI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Net::Address::IP::Cipher encrypts and decrypts IPv6 and IPv4 addresses
to another valid IPv6/v4 address, using a secret key, in a way that's
impossible to guess the original IP without the key.

    use Net::Address::IP::Cipher;

    my $ipcipher = Net::Address::IP::Cipher->new(
        password => 'super secret'
    );
    my $enc = $ipcipher->enc('::1');
    print $enc; # 3a3e:7137:6e36:5ecd:4d31:e516:cf47:ec1b

It's intended use is to pseudo-anonymize IPs from logs, packet captures,
and other analysis. By this way you benefit of having still valid IP
addresses and be able to group streams of several messagess, but without
revealing the source.

This module implements in native perl language the "ipcipher"
specification from:
   https://github.com/PowerDNS/ipcipher

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README ignore.txt
%perl_vendor_privlib/N*

%changelog
