# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/OpenSSL/RSA.pm) perl(Crypt/OpenSSL/VerifyX509.pm) perl(Crypt/OpenSSL/X509.pm) perl(DateTime.pm) perl(DateTime/Format/ISO8601.pm) perl(DateTime/Format/x509.pm) perl(Digest/MD5.pm) perl(Digest/SHA1.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(MIME/Base64.pm) perl(Method/Signatures/Simple.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Try/Tiny.pm) perl(Types/Standard.pm) perl(URI.pm) perl(URI/Normalize.pm)
# END SourceDeps(oneline)
%define module_name Net-Amazon-AlexaValidator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Implements all security-related checks required for Amazon Alexa Skills
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SS/SSIEGAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Highlights of the validation include:

=over

=item *

Verifies the Signature Certificate URL. Amazon's requirements are listed here: https://developer.amazon.com/public/solutions/alexa/alexa-skills-kit/docs/developing-an-alexa-skill-as-a-web-service#h2_verify_sig_cert

=item * 

Downloads the PEM-encoded X.509 certificate chain that Alexa used to sign the message as specified by the SignatureCertChainUrl header value on the request.

=item *

Validates that the signing certificate has not expired (examine both the Not Before and Not After dates).

=item *

Validates that the domain echo-api.amazon.com is present in the Subject Alternative Names (SANs) section of the signing certificate.

=item *

Validates that all certificates in the chain combine to create a chain of trust to a trusted root CA certificate.

=item *

Base64-decodes the Signature header value on the request to obtain the encrypted signature.

=item *

Uses the public key extracted from the signing certificate to decrypt the encrypted signature to produce the asserted hash value. Generates a SHA-1 hash value from the full HTTPS request body to produce the derived hash value, and compares the asserted hash value and derived hash values to ensure that they match.

=item *

Checks the request timestamp to ensure that the request is not an old request being sent as part of a "replay" attack.

=over

=back

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/N*

%changelog
