# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(HTTP/Message.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Test/More.pm) perl(XML/Simple.pm)
# END SourceDeps(oneline)
%define module_version 0.21
%define module_name Net-Amazon-Utils
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.21
Release: alt1
Summary: Implementation of a set of utilities to help in developing Amazon web service modules in Perl.
Group: Development/Perl
License: gpl, artistic
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GB/GBARCO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module implements a set of helpers that should be of aid to
programming client to Amazon RESTful webservices.

Loosely based in com.amazonaws.regions.Region at http://docs.aws.amazon.com/AWSJavaSDK/latest/javadoc/com/amazonaws/regions/Region.html

_use Net::Amazon::Utils;

_my $utils = Net::Amazon::Utils->new();

_# get a list of all regions
_my @all_regions = $utils->get_regions();

_# get a list of all services abbreviations
_my @all_services = $utils->get_services();

_# get all endpoints for ec2
_my @service_endpoints = $utils->get_service_endpoints( 'ec2' );

_my $endpoint_uri;

_# check that ec2 exists in region us-west-1
_if ( $utils->is_service_supported( 'ec2', 'us-west-1' ) ) {
__# check that http is supported by the end point
__if ( $utils->get_http_support( 'ec2', 'us-west-1' ) ) {
___# get the first http endpoint for ec2 in region us-west-1
___$endpoint_uri =($utils->get_endpoint_uris( 'Http', 'ec2', 'us-west-1' ))[0];
___#... use LWP to POST, send get comments
___#... use Net::Amazon::EC2
__}
_}

_# get endpoints for ec2 with http support on two given regions
_my @some_endpoints = $utils->get_http_support( 'ec2', 'us-west-1', 'us-east-1' );

_# check ec2 is supported on all us regions
_my @us_regions = grep( /^us/, $utils->get_regions );
_my @us_endpoints;
_if ( $utils->is_service_supported( 'ec2', @us_regions ) ) {
__# get endpoints for ec2 with http support on all us regions
__@us_endpoints = $utils->get_http_support( 'ec2', @us_regions );
__# choose a random one and give you images a spin
__# ...
_}
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/N*

%changelog
