# BEGIN SourceDeps(oneline):
BuildRequires: perl(IO/Socket.pm) perl(Net/DNS/Packet.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define module_version 0.3
%define module_name Net-Blacklist-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3
Release: alt1
Summary: Queries multiple RBLs or URIBLs in parallel.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DA/DAN/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is used to discover what RBL's are listing a particular IP
address.  It parallelizes requests for fast response.

This module is heavily based on the Net::RBLClient manpage by Asher Blum. It adds
an updated list of RBLs and removes many dead ones, the ability to look
up domains in domain-specific RBLs, and changes the output format.
Although it is very similar and does the same job, due to the changes in
the output formats, it is not suitable as a drop-in replacement.

An RBL, or Realtime Blackhole List, is a list of IP addresses meeting some
criteria such as involvement in Unsolicited Bulk Email.  Each RBL has
its own criteria for addition and removal of addresses.  If you want to
block email or other traffic to/from your network based on one or more
RBLs, you should carefully study the behavior of those RBLs before and
during such blocking.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/N*

%changelog
