%define module_name Net-CalDAVTalk
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/ICal.pm) perl(Data/ICal/Entry/Alarm/Display.pm) perl(Data/ICal/Entry/Alarm/Email.pm) perl(Data/ICal/Entry/Event.pm) perl(Data/ICal/Entry/TimeZone.pm) perl(Data/ICal/Entry/TimeZone/Daylight.pm) perl(Data/ICal/Entry/TimeZone/Standard.pm) perl(Data/ICal/TimeZone.pm) perl(DateTime/Format/ICal.pm) perl(DateTime/Format/ISO8601.pm) perl(DateTime/TimeZone.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(JSON/XS.pm) perl(MIME/Base64.pm) perl(MIME/Types.pm) perl(Net/DAVTalk.pm) perl(Test/More.pm) perl(Text/LevenshteinXS.pm) perl(Text/VCardFast.pm) perl(URI/Escape.pm) perl(XML/Spice.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Module to talk CalDAV and give a JSON interface to the data
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRONG/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is the initial release of the code used at FastMail for talking
to CalDAV servers.  It's quite specific to an early version of our API, so
while it might be useful to others, it's being pushed to CPAN more because
the Cassandane test suite needs it.

See Net::DAVTalk for details on how to specify hosts and paths.

    my $CalDAV = Net::CalDAVTalk->new(
        user => $service->user(),
        password => $service->pass(),
        host => $service->host(),
        port => $service->port(),
        scheme => 'http',
        url => '/',
        expandurl => 1,
    );

or using DNS:

    my $domain = $user;
    $domain =~ s/.*\@//;

    my $url;
    my ($reply) = $Resolver->search("_caldavs._tcp.$domain", "srv");
    if ($reply) {
      my @d = $reply->answer;
      if (@d) {
        my $host = $d[0]->target();
        my $port = $d[0]->port();
        $url = "https://$host";
        $url .= ":$port" unless $port eq 443;
      }
    }

This will use the '/.well-known/caldav' address to find the actual current user
principal, and from there the calendar-home-set for further operations.

    my $foo = Net::CalDAVTalk->new(
       user => $user,
       password => $password,
       url => $url,
       expandurl => 1,
    );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
