%define module_name Net-Connection-Match
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Error/Helper.pm) perl(Net/CIDR.pm) perl(Net/Connection.pm) perl(Net/DNS.pm) perl(Proc/ProcessTable.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.5.0
Release: alt1
Summary: Runs a stack of checks to match Net::Connection objects.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Net::Connection::Match;
    use Net::Connection;
    
    my $connection_args={
                         foreign_host=>'10.0.0.1',
                         foreign_port=>'22',
                         local_host=>'10.0.0.2',
                         local_port=>'12322',
                         proto=>'tcp4',
                         state=>'LISTEN',
                        };
    my $conn=Net::Connection->new( $connection_args );
    
    my %%args=(
              checks=>[
                       {
                        type=>'Ports',
                        invert=>0,
                        args=>{
                               ports=>[
                                       '22',
                                      ],
                               lports=>[
                                        '53',
                                       ],
                               fports=>[
                                        '12345',
                                       ],
                        }
                       },
                       {
                        type=>'Protos',
                        invert=>0,
                        args=>{
                               protos=>[
                                        'tcp4',
                                       ],
                        }
                       }
                      ]
             );
    
    my $checker;
    eval{
        $checker=Net::Connection::Match->new( \%%args );
    } or die "New failed with...".$@;
    
    if ( $check->match( $conn ) ){
        print "It matched!\n";
    }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README ignore.txt
%perl_vendor_privlib/N*

%changelog
