%define module_name Net-DHCP-Config-Utilities
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/Tiny.pm) perl(File/Find/Rule.pm) perl(Net/CIDR.pm) perl(Net/CIDR/Overlap.pm) perl(Net/CIDR/Set.pm) perl(String/ShellQuote.pm) perl(Template.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.0
Release: alt1
Summary: Utility for helping generate configs for DHCP servers and manage subnets.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Please note that this only supports IPv4 currently.

    use Net::DHCP::Config::Utilities;
    use Net::DHCP::Config::Utilities::INI_loader;
    
    my $dhcp_util = Net::DHCP::Config::Utilities->new;
    
    # load stuff from a file
    my $loader = Net::DHCP::Config::Utilities::INI_loader->new( $dhcp_util );
    eval{
        $loader->load_file( $file );
    };
    if ( $@ ){
        # do something upon error
        die( $@ );
    }
    
    # create and add a new subnet
    my $options={
                 base=>'10.0.0.0',
                 mask=>'255.255.255.0',
                 dns=>'10.0.0.1 , 10.0.10.1',
                 desc=>'a example subnet',
                 };
    my $subnet = Net::DHCP::Config::Utilities::Subnet->new( $options );
    eval{
        $dhcp_util->subnet_add( $subnet );
    };
    if ( $@ ){
        # do something upon error
        die( $@ );
    }

    my @subnets=$dhcp_util->subnet_list;
    print "Subnets:\n".join("\n", @subnets)."\n";

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%files scripts
%_bindir/*

%changelog
