%define module_name Net-Domain-Registration-Check
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(Net/DNS.pm) perl(Net/Domain/TLD.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Fast check on availability of domain registration
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PY/PYH/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
This module takes a quick check on domain registration, to find out if the domain is available or not.

It doesn't query to whois server, but checks if domain exists on its parent nameservers.

So it gets a quick check response.

For domain which is redemptionPeriod status, it does not get listed on parent nameservers, but you can't register it from the registrar this time. See: https://icann.org/epp#redemptionPeriod

It makes no sense on second-level ccTLDs, such as com.cn, co.uk etc. For IANA official root zone DB please see: https://www.iana.org/domains/root/db

.Ua.U..'..iU.'a.YA.e'.ee.'a.''.''.'U.'I.'U.Oa.AA.uU.''.e'

.O'.vc.a'.'a.UAwhois.''.'..'U.''.e'.'U.ee.'a.Ua.''.''.'U.'I.d'.'U.a'.'c.ae.ai.''.''.d..''.'..'U.a'.e'

.'e.Oa.O'.''.'a.UA.''.aa.Y'.e'.''.Y'.YA.a'whois.

.''.a'.''.'o.'I.''.''.''.I'.a'redemptionPeriod.'c.e'.''.O'..O.O'.a'.d'.'U.a'.'c.ae.ai.''.d..''.'..'U.a'.''.A'.'U.Y'.au..c.e'.Ao.Y'.a'.'A.uU.''.e'.U..i'.''https://icann.org/epp#redemptionPeriod

.Ua.U..'..vc.a'.'A.'a.UA.'OccTLD.''.''.''.'A.'u..N.O'.AO.''.a'.ai.''.''.''.Ui.I'com.cn.''co.uk.e'IANA.O'.'v.O'.v'.''..c.ai.''.''gTLD.''.'A.Oc.ai.''.''ccTLD.U..i'.''https://www.iana.org/domains/root/db

Usage:

    use Net::Domain::Registration::Check;
_
    print domain_on_parent($domain) ? "domain has been taken" : "domain may not be taken";

Run via command line:

    $ perl -MNet::Domain::Registration::Check -le 'print domain_on_parent(+shift)' yahoo.com
    1

    $ perl -MNet::Domain::Registration::Check -le 'print domain_on_parent(+shift)' yahoo.io
    1

    $ perl -MNet::Domain::Registration::Check -le 'print domain_on_parent(+shift)' yahoo.email
    1

    $ perl -MNet::Domain::Registration::Check -le 'print domain_on_parent(+shift)' yahoo234.com
    0

    $ perl -MNet::Domain::Registration::Check -le 'print domain_on_parent(+shift)' yahoo.nonexist
    domain TLD not exists at -e line 1
%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt README Changes
%perl_vendor_privlib/N*

%changelog
