# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(IO/Socket/INET.pm) perl(Test/Builder.pm)
# END SourceDeps(oneline)
%define module_version 0.18
%define module_name Net-FileShare
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: Object oriented interface for the creation of file sharing clients and servers.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GR/GRAVALO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This distribution represents a complete rewrite of the `Net::FileShare' code base. Every aspect has been rewritten to improve upon methodology. If you're currently running the 1.X code base its serously suggested that you download this new 0.1X code and install. See the changes file contained within this distribution for the specifics on how the `Net::FileShare' code has been changed/improved in the 0.1X distribution.  .
=item new()

The `Net::FileShare' new() method creates an object, which can then be used to construct either a server or client. There are three has values which can be used to construct the object. They are as follows: _send_only (1 for on, 0 for off), _directory (path to files to share or download directory), and _debug (1 for on, 0 for off). 
 For the construction of servers, _send_only and _directory are required values to set. Clients are only required to supply the _directory value.
 Note: avoid the use of a trailing slash when listing your path for the _directory option:
	/home/my_login_name	## good
	/home/my_login_name/	## bad
 The next version of this code will fix this problem. 

=item server_connection()

The server_connection sub impliments a forking filesharing server. Its first action is to establish a socket, then begin the process of accepting clients. Once a client connection is accepted, the connection is forked. If this is successful the server then initiates the handle_request sub, which interfaces with client.

=item client_automated()

This is an automated version of the interactive client session. It is a run once session. The user must supply either three or four parameters here. They are IP of server, port of server, command (either list or get), and an optional file name (if command = get). 
 See EXAMPLES above.

=item client_interactive()

This is the interactive client connection. It begins with a client connection to a server running the `Net::FileShare' module. Once the client connection has been established, the client process will be forked. Once this occurs, the client the begins and interactive session where it can request either a list of files the server is offering, or a specific file. 
 The user must supply two variables here. Those are the IP of server and port of server. See EXAMPLES above.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO README Changes examples
%perl_vendor_privlib/N*

%changelog
