# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl(Net/Frame/Dump/Online.pm) perl(Net/Frame/Simple.pm) perl(Net/Write/Layer2.pm) perl(Net/Write/Layer3.pm) perl(Socket6.pm) perl-podlators
# END SourceDeps(oneline)
# need network
%define _without_test 1
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Net-Frame
%define upstream_version 1.21

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    BSD loopback layer object
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Net/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Bit/Vector.pm)
BuildRequires: perl(Class/Gomor.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Math/BigInt.pm)
BuildRequires: perl-Math-BigInt
BuildRequires: perl(Net/IPv6Addr.pm)
BuildRequires: perl(Socket.pm)
BuildArch:  noarch
Source44: import.info

%description
*Net::Frame* is a fork of *Net::Packet*. The goal here was to greatly
simplify the use of the frame crafting framework. *Net::Packet* does many
things undercover, and it was difficult to document all the thingies.

Also, *Net::Packet* may suffer from unease of use, because frames were
assembled using layers stored in L2, L3, L4 and L7 attributes. *Net::Frame*
removes all this, and is split into different modules for those who only
want to use part of the framework, and not whole framework.

Finally, anyone can create a layer, and put it on his CPAN space, because
of the modularity *Net::Frame* offers. For an example, see
*Net::Frame::Layer::ICMPv4* on my CPAN space.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build CFLAGS="%{optflags}"

%check
# (tv) disable tests that need networking:
rm -f t/13-gethostsubs.t
make test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README examples
%perl_vendor_privlib/*


%changelog
