%define module_name Net-Google-Drive-Simple
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/MMagic.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Log/Log4perl.pm) perl(MIME/Base64.pm) perl(Mojolicious.pm) perl(OAuth/Cmdline.pm) perl(Pod/Usage.pm) perl(Sysadm/Install.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(Test2/Plugin/NoWarnings.pm) perl(Test2/Tools/Explain.pm) perl(Test2/V0.pm) perl(URI.pm) perl(URI/QueryParam.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.02
Release: alt1
Summary: Simple modification of Google Drive data
Group: Development/Perl
License: perl
URL: https://github.com/mschilli/net-google-drive-simple

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AT/ATOOMIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Net::Google::Drive::Simple authenticates with a user's Google Drive and
offers several convenience methods to list, retrieve, and modify the data
stored in the 'cloud'. See `eg/google-drive-upsync' as an example on how
to keep a local directory in sync with a remote directory on Google Drive.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install
# strange perls in '#!'
fix_shabang_in_perl()
{
	local f="$1"
	#!/usr/bin/perl -w -- -*- mode: cperl -*-
	sed -i -e '1s,^#\![[:space:]]*\(/usr\)\?/bin/env[[:space:]]*perl,#!/usr/bin/perl,;1s,-\*-[[:space:]]*cperl[[:space:]]*-\*-,,;1s,-\*-[[:space:]]*[Mm]ode:[[:space:]]*[Cc]?[pP]erl[[:space:]]*-\*-,,' $f 
	sed -i -e '1s,^#\!/usr/local/bin/perl,#!/usr/bin/perl,' $f 
}
for dir in %buildroot%_bindir %buildroot%perl_vendor_archlib %buildroot%perl_vendor_privlib ; do
    if [ -d $dir ]; then
    	find $dir -type f -executable | while read f; do
	  case `file $f` in
	    *perl*) fix_shabang_in_perl $f 
	    ;;
	  esac
	done
	find $dir -type f \( -name '*.pm' -or -name '*.pl' \) | while read f; do
	  fix_shabang_in_perl $f
	done
    fi
done


%files
%doc Changes README LICENSE
%perl_vendor_privlib/N*

%changelog
