%define module_name Net-IMP-HTTP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(Image/Magick.pm) perl(Net/IMP.pm) perl(Net/Inspect.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.525
Release: alt1
Summary: interface for HTTP specific the Net::IMP manpage plugins
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SU/SULLR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Net::IMP::HTTP modules make it easier to write HTTP specific IMP plugins.
We distinguish between HTTP connection specific plugins and HTTP request
specific plugins.
The differences are:

=over 4

=item *

The offset in the return values of the plugins relates for connection specific
plugins to the connection (which might contain multiple requests), while for
request specific plugins it starts anew for each request.

Similar IMP_MAXOFFSET means the end of connection for connection specific
plugins, while end of request for request specific plugins.

=item *

Connection specific plugins get info about framing, e.g. junk data and framing
of chunked encoding (chunked header and trailers). Request specific plugins
only get header and content.

=item *

Connection specific plugins see the raw bodies of the request, while request
specific plugins see the content, e.g. the body stripped from framing (chunked
encoding) and transfer encodings (this includes content-encodings for
compression, which are in reality used as transfer encodings).

Similar it is expected, that connection specific plugins fix framing or
content-length headers themself, when changing data. For request specific
plugins the caller of the plugin is expected to adjust these.

=back

The following modules are currently implemented or planned:

=over 4

=item Net::IMP::HTTP

This module provides the data type definitions for HTTP connection and request
types.

=item Net::IMP::HTTP::Connection

This module is a base class for IMP plugins working with HTTP connection types.

=item Net::IMP::HTTP::Request

This module is a base class for IMP plugins working with HTTP request types.

=item Net::IMP::Adaptor::STREAM2HTTPConn

Using this module can adapt HTTP connection specific plugins into a simple
stream interface (IMP_DATA_STREAM)

=item Net::IMP::Adaptor::STREAM2HTTPReq (planned)

Using this module can adapt HTTP request specific plugins into a simple
stream interface (IMP_DATA_STREAM).

=back

`Net::IMP::HTTP' defines the following constants for HTTP specific data types

=over 4

=item connection specific types

  IMP_DATA_HTTP_HEADER     - request and response header
  IMP_DATA_HTTP_BODY       - request and response body chunks (stream)
  IMP_DATA_HTTP_CHKHDR     - chunk header in chunked transfer encoding
  IMP_DATA_HTTP_CHKTRAILER - chunk trailer in chunked transfer encoding
  IMP_DATA_HTTP_DATA       - arbitrary data after connection upgrades (stream)
  IMP_DATA_HTTP_JUNK       - junk data (leading new lines before header..)

=item request specific types

  IMP_DATA_HTTPRQ_HEADER  - request and response header
  IMP_DATA_HTTPRQ_CONTENT - request and response body chunks (stream)
  IMP_DATA_HTTPRQ_DATA    - arbitrary data after connection upgrades (stream)

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYRIGHT README
%perl_vendor_privlib/N*

%changelog
