Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/Socket/SSL.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-IRC
Version:        0.79
Release:        alt2_40
Summary:        Perl interface to the Internet Relay Chat protocol
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Net-IRC
Source0:        https://cpan.metacpan.org/authors/id/A/AP/APEIRON/Net-IRC-%{version}.tar.gz
# Avoid interactive build
Patch0:         Net-IRC-0.79-confirm.patch
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
# Runtime
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(IO/Select.pm)
BuildRequires:  perl(IO/Socket.pm)
BuildRequires:  perl(IO/Socket/INET.pm)
# XXX: BuildRequires:  perl(IO::Socket::SSL)
BuildRequires:  perl(Socket.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(subs.pm)
BuildRequires:  perl(Symbol.pm)
BuildRequires:  perl(Time/HiRes.pm)
BuildRequires:  perl(vars.pm)
BuildRequires:  perl(warnings.pm)
# Tests only
BuildRequires:  perl(Test.pm)
Requires:       perl(IO/Socket/SSL.pm)
Requires:       perl(Time/HiRes.pm)
Source44: import.info

%description
Perl implementation of the IRC protocol (RFC 1459).

%prep
%setup -qn Net-IRC-%{version}
%patch0  -p1
chmod -x irctest

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes README irctest
%{perl_vendor_privlib}/*

%changelog
