%define module_version 0.604
%define module_name Net-IdentServer
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/INET.pm) perl(Net/Server.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.604
Release: alt1
Summary: An rfc 1413 Ident server which @ISA [is a] Net::Server.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JE/JETTERO/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Although you can run this as you see in the SYNOPSIS, you'll
probably want to rewrite a few things.

Net::IdentServer is a child of Net::Server to be sure.  If
you wish to override the behaviours of this module, just
inherit it and start re-writing as you go.  

An example random fifteen-letter-word ident server follows:

    use strict;

    my $s = new RandomIdentServer;

    run $s;

    package RandomIdentServer;

    use strict;
    use base qw(Net::IdentServer);

    1;

    sub new {
        my $class = shift;
        my $this = $class->SUPER::new( @_ );

        open IN, "/usr/share/dict/words" or die "couldn't open dictionary: $!";
        while(<IN>) {
            if( /^(\S{15})$/ ) {
                push @{ $this->{words} }, $1;
            }
        }
        close IN;

        return $this;
    }

    sub choice {
        my $this = shift;

        my $i = int rand @{ $this->{words} };

        return $this->{words}->[$i];
    }

    sub print_response {
        my $this = shift;
        my ($local, $remote, $type, $info) = @_;

        if( $type eq "UNIX" ) {
            # intercept these valid responses and randomize them

            $info = $this->choice;
        }

        # Do what we would have done
        $this->SUPER::print_response( $local, $remote, $type, $info );
    }


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
