# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(IO/All.pm) perl(JSON/XS.pm) perl(LWP/UserAgent.pm) perl(Module/Build/Tiny.pm) perl(Test/CheckManifest.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 0.1.0
%define module_name Net-Marathon
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.0
Release: alt1
Summary: An object-oriented Mapper for the Marathon REST API, fork of Marathon module
Group: Development/Perl
License: perl
URL: https://github.com/tynovsky/Net-Marathon

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TY/TYNOVSKY/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Net::Marathon 0.1.0 is a fork of Marathon 0.9 with a fix on Events API (applied this patch https://github.com/geidies/perl-Marathon/pull/1).
Otherwise it is the same, more differences may come in future versions.

This module is a wrapper around the [Marathon REST API](http://mesosphere.github.io/marathon/docs/rest-api.html), so it can be used without having to write JSON by hand.

For the most common tasks, there is a helper method in the main module. Some additional methods are found in the Net::Marathon::App etc. submodules.

To start, create a marathon object:

    my $m = Net::Marathon->new( url => 'http://my.marathon.here:8080' );

    my $app = $m->get_app('hello-marathon');

    $app->instances( 23 );
    $app->update();
    print STDERR Dumper( $app->deployments );

    sleep 10;

    $app->instances( 1 );
    $app->update( {force => 'true'} ); # should work even if the scaling up is not done yet.



%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes
%perl_vendor_privlib/N*

%changelog
