%define module_name Net-Matrix-Webhook
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Accessor/Fast.pm) perl(Digest/SHA1.pm) perl(Encode.pm) perl(IO/Async/Loop.pm) perl(IO/Async/SSL.pm) perl(IO/Async/Timer/Countdown.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/Any.pm) perl(Log/Any/Adapter.pm) perl(Module/Build.pm) perl(Net/Async/HTTP/Server/PSGI.pm) perl(Net/Async/Matrix.pm) perl(Plack/Request.pm) perl(Plack/Response.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.901
Release: alt1
Summary: A http->matrix webhook
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DO/DOMM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
L[matrix|https://matrix.org/] is an open network for secure, decentralized communication. A bit like IRC, but less 90ies.

`Net::Matrix::Webhook' implements a webhook, so you can easily post messages to your matrix chat rooms via HTTP requests. It uses the IO::Async manpage to start a web server and connect as a client to matrix. It will then forward your messages.

Per default, everybody can now post to this endpoint. If you want to add a tiny bit of "security", you can pass a `secret' to `Net::Matrix::Webhook'. If you do this, you will also have to send a `token' consisting of a `sha1_hex' of the message and the secret:

  my $token = sha1_hex( encode_utf8($msg), $secret );
  request('http://localhost:8765/?message=hello%%2C%%20world%%21&token='.$token);

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/N*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
