%define module_name Net-OAuth2-AuthorizationServer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/JWT.pm) perl(CryptX.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Moo.pm) perl(Test/Exception.pm) perl(Test/Most.pm) perl(Time/HiRes.pm) perl(Try/Tiny.pm) perl(Types/Standard.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.28
Release: alt1
Summary: Easier implementation of an OAuth2 Authorization Server
Group: Development/Perl
License: perl
URL: https://metacpan.org/module/Net::OAuth2::AuthorizationServer

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEEJO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is the gateway to the various OAuth2 grant flows, as documented
at https://tools.ietf.org/html/rfc6749. Each module implements a specific
grant flow and is designed to "just work" with minimal detail and effort.

Please see the Net::OAuth2::AuthorizationServer::Manual manpage for more information
on how to use this module and the various grant types. You should use the manual
in conjunction with the grant type module you are using to understand how to
override the defaults if the "just work" mode isn't good enough for you.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes examples
%perl_vendor_privlib/N*

%changelog
