%define module_name Net-OAuth2Server
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN/Meta.pm) perl(Carp.pm) perl(MIME/Base64.pm) perl(Object/Tiny/Lvalue.pm) perl(Plack/Request.pm) perl(Pod/Readme/Brief.pm) perl(Software/LicenseUtils.pm) perl(URI/Escape.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: A light, simple, flexible OAuth2 server framework
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AR/ARISTOTLE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A server-side OAuth2 framework with the following aims:

=over 2

=item * Well designed for direct use as-is within a web application

Application programmers should have a reasonable abstraction to build on
so they can fill in the specifics of their application
without having to reimplement significant parts of the protocol anyway.

=item * Extensible enough as a framework to implement any OAuth2 extension

It should be possible to implement any OAuth2 extension
such that it can easily be shipped as a CPAN module.

=item * Independent from specific web frameworks

It should not be necessary to reimplement OAuth2 as a plugin or extension
for every single framework.

=item * Frugal in dependencies and means of implementation

OAuth2 is not deep or clever technology, it is glue.
There is no need for anything deep or clever in an implementation of it.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README
%perl_vendor_privlib/N*

%changelog
