# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config/INI/Reader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(FindBin.pm) perl(JSON/XS.pm) perl(LWP/UserAgent.pm) perl(MIME/Base64.pm) perl(Module/Load.pm) perl(REST/Client.pm) perl(Readonly.pm) perl(Set/Scalar.pm) perl(Template.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Warnings.pm) perl(base.pm) perl(lib.pm) perl(overload.pm) perl(parent.pm) perl(strict.pm) perl(version.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Net-OpenStack-Client
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.4
Release: alt1
Summary: OpenStack REST API client
Group: Development/Perl
License: apache
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STDWEIRD/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Example usage:
    use Net::OpenStack::Client;
    ...
    my $cl = Net::OpenStack::Client->new(openrc => '/home/admin/.openrc');

For basic reporting:
    use Net::OpenStack::Client;
    use Log::Log4perl qw(:easy);
    Log::Log4perl->easy_init($INFO);
    ...
    my $cl = Net::OpenStack::Client->new(
        openrc => '/home/admin/.openrc',
        log => Log::Log4perl->get_logger()
        );

For debugging, including full JSON request / repsonse and headers (so contains sensitive data!):
    use Net::OpenStack::Client;
    use Log::Log4perl qw(:easy);
    Log::Log4perl->easy_init($DEBUG);
    ...
    my $cl = Net::OpenStack::Client->new(
        openrc => '/home/admin/.openrc',
        log => Log::Log4perl->get_logger(),
        debugapi => 1
        );

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README LICENSE License
%perl_vendor_privlib/N*

%changelog
