# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request/Common.pm) perl(LWP/UserAgent.pm) perl(Storable.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(URI.pm) perl(Want.pm)
# END SourceDeps(oneline)
%define module_version 0.11
%define module_name Net-Rest-Generic
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: A tool for generically interacting with restfull (or restlike) APIs.
Group: Development/Perl
License: Artistic_2_0
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SU/SUTT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Net::Rest::Generic is a module for interacting with arbitrary HTTP/S APIs.
It attempts to do this by providing an easy to read syntax for generating the request
URLs on the fly, and generally Doing The Right Thing.

A basic example:

    use Net::Rest::Generic;

    my $api = Net::Rest::Generic->new(
__host => "api.foo.com",
__scheme => "https",
__base => "api/v1",
__authorization_basic => {
___username => "user",
___password => "password",
__}
_);
    my $result = $api->setRequestMethod("POST")->this->is->the->url("parameterized")->addLabel("new");

    my $details = $api->setRequestMethod("GET")->user("superUser")->details->color->favorite;
    ...


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/N*

%changelog
