%define module_name Net-SAML2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/OpenSSL/Bignum.pm) perl(Crypt/OpenSSL/RSA.pm) perl(Crypt/OpenSSL/Random.pm) perl(Crypt/OpenSSL/Verify.pm) perl(Crypt/OpenSSL/X509.pm) perl(DateTime.pm) perl(DateTime/Format/XSD.pm) perl(DateTime/HiRes.pm) perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurper.pm) perl(HTTP/Request/Common.pm) perl(IO/Compress/RawDeflate.pm) perl(IO/Uncompress/RawInflate.pm) perl(Import/Into.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(List/Util.pm) perl(MIME/Base64.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(MooseX/Test/Role.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Common/String.pm) perl(MooseX/Types/DateTime.pm) perl(MooseX/Types/Moose.pm) perl(MooseX/Types/URI.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Sub/Override.pm) perl(Test/Deep.pm)
BuildRequires: perl(Test/EOL.pm) perl(Test/Exception.pm) perl(Test/Fatal.pm) perl(Test/Lib.pm) perl(Test/Mock/One.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Try/Tiny.pm) perl(Types/Serialiser.pm) perl(URI.pm) perl(URI/Encode.pm) perl(URI/Escape.pm) perl(URI/QueryParam.pm) perl(URN/OASIS/SAML2.pm) perl(XML/Enc.pm) perl(XML/Generator.pm) perl(XML/LibXML.pm) perl(XML/LibXML/XPathContext.pm) perl(XML/Sig.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.82
Release: alt1
Summary: SAML bindings and protocol implementation
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TI/TIMLEGGE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Support for the Web Browser SSO profile of SAML2.

Net::SAML2 correctly perform the SSO process against numerous SAML
Identity Providers (IdPs).  It has been tested against:

=over

=item GSuite (Google)

=item Azure (Microsoft Office 365)

=item OneLogin

=item Jump

=item Mircosoft ADFS

=item Keycloak

=item Auth0 (requires Net::SAML2 >=0.39)

=item PingIdentity

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TUTORIAL.md LICENSE CONTRIBUTING.md README CONTRIBUTORS Changes
%perl_vendor_privlib/N*

%changelog
