%def_without test
# BEGIN SourceDeps(oneline):
BuildRequires: perl(BSD/Resource.pm) perl(Errno.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(IO/Dir.pm) perl(IO/File.pm) perl(POSIX.pm) perl(Stat/lsMode.pm) perl(Sys/Syslog.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.1.0
%define module_name Net-SFTP-SftpServer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.0
Release: alt1
Summary: Secure File Transfer Protocol Server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SI/SIMM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
A Perl port of sftp-server from openssh providing access control on a per user per command basis and improved logging via syslog

The limitations compared with the openssh implementation are as follows:

=over

=item *

Only files and directories are dealt with - other types are not returned on readdir

=item *

a virtual chroot is performed - / is treated as the users home directory from the
client perspective and all file access to / will be in /<home_path>/<username>
home_path is defined on object initialisation not accessed from /etc/passwd
The script DOES NOT run under chroot - this prevents it needing SUID to start.
The virtual chroot is enforced by the objects and prevent opperations outside the
home area

=item *

all sym linked files or directories are hidden and not accessible on request

=item *

symlink returns permission denied. Please contact me if you need this functionaility implementing

=item *

readlink returns file does not exist. Please contact me if you need this functionaility implementing

=item *

setting of stats (set_stat or set_fstat) is disabled - client will receive permission denied.
Please contact me if you need this functionaility implementing

=item *

permissions for file or dir is defaulted - default set on object initialisation

=back

%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README
%perl_vendor_privlib/N*

%changelog
