# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Net-SMTP-TLS-ButMaintained
%define upstream_version 0.24

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_9
Summary:    An SMTP client supporting TLS and AUTH
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Net/%{upstream_name}-%{upstream_version}.tar.gz
BuildRequires: perl(Digest/HMAC_MD5.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(IO/Socket/INET.pm)
BuildRequires: perl(IO/Socket/SSL.pm)
BuildRequires: perl(MIME/Base64.pm)
BuildRequires: perl(Net/Cmd.pm)
BuildRequires: perl(Net/SSLeay.pm)
BuildArch:  noarch
Source44: import.info

%description
*Net::SMTP::TLS::ButMaintained* is forked from the Net::SMTP::TLS manpage.
blame 'Evan Carroll' for the idea. :)

*Net::SMTP::TLS::ButMaintained* is a TLS and AUTH capable SMTP client which
offers an interface that users will find familiar from the Net::SMTP
manpage. *Net::SMTP::TLS::ButMaintained* implements a subset of the methods
provided by that module, but certainly not (yet) a complete mirror image of
that API.

The methods supported by *Net::SMTP::TLS::ButMaintained* are used in the
above example. Though self explanatory for the most part, please see the
perldoc for the Net::SMTP manpage if you are unclear.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*


%changelog
