# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(Moose.pm) perl(MooseX/Getopt.pm) perl(Net/Cmd.pm) perl(Net/DNS/Resolver.pm) perl(Net/SMTP.pm) perl(Sys/Hostname.pm) perl(Test/Exception.pm) perl(Test/Mock/Net/Server/Mail.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Net-SMTP-Verify
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: verify SMTP recipient addresses
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BE/BENNING/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class implements checks for verifying SMTP addresses.

It implements the following checks:

=over

=item check addresses with SMTP MAIL FROM and RCPT TO commands

Check if the MX would accept mail for test addresses.

=item check of message size

If the mail exchanger (MX) supports the SIZE extension and a size is given the
module will pass the message size with the MAIL FROM command.

This will check if the message would exceed message size limits or recipients
quotas on the target MX.

=item check if MX could handle TLS connections

It will check if the STARTTLS extension required to enstablish encrypted TLS
connections is supported by the target MX.

=item check if TLSA record is available

The module could check if a TLSA record has been published for the target MX
server.

If such a record has been published the target MX SSL certificate could be
verified with DANE.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README CHANGES README.pod
%perl_vendor_privlib/N*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
