# BEGIN SourceDeps(oneline):
BuildRequires: perl(DBM/Deep.pm) perl(ExtUtils/MakeMaker.pm) perl(LWP/Simple.pm)
# END SourceDeps(oneline)
%define module_version 0.01a
%define module_name Net-SNMP-Vendor
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01a
Release: alt1
Summary: lookup the Vendor for a sysObjectID based on the
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/E/EN/ENDLER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
The Internet Assigned Numbers Association (www.iana.org) maintains 
a list of all assgined sysObjectID which can be used to determine
the vendor of a SNMP agent. Futhermore this ID points usually to
an entry in the vendors SMI within the enterprise subtree under
'`.1.3.6.1.4.1''.

To obtain the sysObjectID perform a SNMP get_request operation on
the SNMP agent for the following OID '`.1.3.6.1.2.1.1.2.0''. The result
will be as described above a dotted decimal string with the prefix
'`.1.3.6.1.4'' followed by the vendors identification ID and the vendor
assigned device ID.

You might then either pass the whole string or the extracted vendor
ID to the module as described above. If the ID is assigned and in 
the cache the	module will return a hash reference to a vendor 
object giving all information stored by the IANA for that certain
vendor ID. If the ID is unkown the module will return undef. To
get the cause for the error you might call the `get_error()'
function.

This module tries to persistently cache with `DBM::Deep' the vendor
information to avoid obsesive network use. If you prefer not to
store the result persistently you might use `Net::SNMP::Vendor::CACHE'
in combination with the `type' option in the constructor. That will
cause the module to store the loaded list within a normal hash reference

NOTE: The result will be lost as soon as the process finishes that created
the hash.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/N*

%changelog
