%define module_name Net-SNMP-XS
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Canary/Stability.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Net/SNMP.pm) perl(XSLoader.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.34
Release: alt4
Summary: speed up Net::SNMP by decoding in XS, with limitations
Group: Development/Perl
License: see COPYING
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz

%description
This module tries to speed up Net::SNMP response packet decoding..
It does this by overriding a few selected internal method by (almost)
equivalent XS methods.

This currently reduces decode time by a factor of ten for typical bulk
responses.

There are currently the following limitations when using this module:

=over 4

=item overriding internal functions might cause the module to
malfunction with future versions of Net::SNMP

=item error messages will be simpler/different

=item translation will be ignored (all values will be delivered "raw")

=item a moderately modern (>= C99) C compiler is required

=item only tested with 5.10, no intentions to port to older perls

=item duplicate OIDs are not supported

=item REPORT PDUs are not supported

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README COPYING
%perl_vendor_archlib/N*
%perl_vendor_autolib/*

%changelog
