%define module_version 0.06
%define module_name Net-SNTP-Server
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket/INET.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: Perl Module SNTP Server based on L<RFC4330|https://tools.ietf.org/html/rfc4330>
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GA/GARYFALOS/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module exports a single method (basicSNTPSetup) and returns
 an associative hash output, based on the user input. In case
 of an error, the connection will be terminated and an error string
 will be printed with the possible cause.

The response from the SNTP server is been encoded to a human readable
 format. The obtained information received from the server on the client
 side can be used into further processing or manipulation according to the
 user needs. Maximum accuracy down to nano seconds can only be achieved based
 on different OS.

=over 2

=item * IP

    -ip: Is not a mandatory for the method key to operate correctly.
    By default the module will assign the localhost IP ("127.0.0.1"),
    but this will restrict the server to localhost communications (only
    internally it can receive and transmit data).


=item * PORT

    -port: Is a mandatory key, that the user must define. By default the
    port is not set. The user has to specify the port. We can not use the
    default 123 NTP due to permission. The user has to choose a port number
    identical to port that the client will use client to communicate with
    the server (e.g. -port => 123456).

=back
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/N*

%changelog
