Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Net/HTTPS.pm) perl(URI.pm) perl(URI/Escape.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Net-SSLGlue
Version:        1.058
Release:        alt2_27
Summary:        Add/extend SSL support for common perl modules
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl

URL:            https://metacpan.org/release/Net-SSLGlue
Source0:        https://cpan.metacpan.org/authors/id/S/SU/SULLR/Net-SSLGlue-%{version}.tar.gz

# Remove interactive question
# Only minimal test which doesnt requires Internet connexion
Patch0:         perl-Net-SSLGlue-test.patch

BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(IO/Socket/SSL.pm)
# Required to have tests effective
BuildRequires:  perl(LWP/Protocol/https.pm)
BuildRequires:  perl(Net/LDAP.pm)
BuildRequires:  perl(Net/SMTP.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)

Requires:       perl(LWP/UserAgent.pm) >= 6.060
Requires:       perl(LWP/Protocol/https.pm) >= 6.060
Requires:       perl(Net/FTP.pm)
Requires:       perl(Net/FTP/dataconn.pm)





Source44: import.info
%filter_from_requires /^perl(IO.Socket.SSL.pm)/d
%filter_from_requires /^perl(LWP.UserAgent.pm)/d


%description
Some commonly used perl modules don't have SSL support at all, even if the
protocol would support it. Others have SSL support, but most of them don't
do proper checking of the servers certificate.

The Net::SSLGlue::* modules try to add SSL support or proper certificate to
these modules. Currently is support for the following modules available:

- Net::SMTP - add SSL from beginning or using STARTTLS
- Net::LDAP - add proper certificate checking
- LWP - add proper certificate checking 


%prep
%setup -q -n Net-SSLGlue-%{version}
%patch0  -p0


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build


%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*


%check
make test


%files
%doc README Changes examples
%doc --no-dereference COPYRIGHT
%{perl_vendor_privlib}/Net


%changelog
