%define module_name Net-SharePoint-Basic
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Data/UUID.pm) perl(Exporter.pm) perl(File/Basename.pm) perl(File/Path.pm) perl(Getopt/Long.pm) perl(IO/Scalar.pm) perl(JSON/XS.pm) perl(LWP/UserAgent.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Storable.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(URI/Escape.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: Basic interface to Microsoft SharePoint REST API
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RO/ROMM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Net::SharePoint::Basic - Basic interface to Microsoft SharePoint REST API.

This module provides a basic interface for managing the Shared Documents catalog in the Microsoft SharePoint site via its REST API. In the current version only the following actions are supported:

 * generating a connection token
 * upload file or string
 * download file content and save it
 * list contents of folder
 * create new folder
 * delete file or folder

More actions are expected to be added in the future as well as we plan to increase the versatility of the arguments accepted by this module and the sample implementation of a client, 'sp-client', that comes with it.

The interface is object oriented. A few constants are exported.

The full testing (and naturally the full usage) of the module requires a working SharePoint site configuration. The structure of the configuration file will be described in this manual as well. The sample configuration file provided in this distribution will not work against SharePoint and plays the role of a placeholder only.

    use Net::SharePoint::Basic;

    my $sp = Net::SharePoint::Basic->new({config_file => 'sharepoint.conf'});
    # creates Shared Documents/test
    my $response = $sp->makedir({retries => 1}, '/test');
    # uploads a string as Shared Documents/test/teststring
    $sp->upload({}, '/test/teststring', 'abcd');
    # uploads a file 'testfile' into Shared Documents/test/
    $sp->upload({type => 'file'}, '/test/', 'testfile');
    # downloads contents of a file
    $sp->download({}, '/test/teststring');
    # downloads contents and saves it to a file
    $sp->download({save_file => 'testfile'}, '/test/teststring');
    # lists contents of a folder
    $sp->list({}, '/test');
    # deletes the folder
    $sp->delete({}, '/test');

This module was developed based on the MSDN SharePoint REST API at https://msdn.microsoft.com/en-us/library/office/jj860569.aspx .

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README CONTRIBUTING.md ignore.txt README.md LICENSE.txt NOTICE.txt Changes CODE_OF_CONDUCT.md
%perl_vendor_privlib/N*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
