# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(WebService/Simple.pm)
# END SourceDeps(oneline)
%define module_name Net-Twitch-API
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.11
Release: alt1
Summary: Helper methods for Twitch's "new" helix API
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CL/CLIPLAND/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides methods and helper wrappers to work with what Twitch "new" helix API. The *new* API is
prefixed with the *helix* codename/namespace and the successor of the old *kraken* API which was decommissioned
on February 28, 2022. A little more about that on dev.twitch.tv "legacy v5 integrations" migration guide.

Using this module to issue requests against Twitch's API requires you to register your "application" with Twitch
first. Authentication then is either faciliated via OAuth 2.0
or OpenID Connect. We here use the OAuth2 scheme.

Twitch uses several types of auth tokens. Use the twitch CLI client to obtain an "app access token". This type of
token enables your app to make secure API requests that are not on behalf of a specific user. App access tokens are
meant only for server-to-server API requests and should never be included in client code. Normally, such tokens
would be programmatically refreshed at arbitrary intervals according to OAuth2 RFC but on Twitch app access tokens
are valid for 60 days and cannot be refreshed.

This module uses Yosukebe's excellent the WebService::Simple manpage as base calss. So look there for addditonal documentation.
You might also note that Yosukebe himself recently switched over to the newer the WebService::Client manpage, but that's a
Moo based module.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/N*

%changelog
