# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/Socket.pm) perl(Scrappy.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.6
%define module_name Net-Whois-RIS
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.6
Release: alt1
Summary: Whois lookup on RIPE RIS
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/A/AD/ADULAU/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
The module query the RIPE Routing Information Service (RIS) whois to get
information about a specific IP address. You can get information
like the AS number announcing the IP address/network.

    use Net::Whois::RIS;

    my $foo = Net::Whois::RIS->new();
    $foo->getIPInfo("8.8.8.8");
    print $foo->getOrigin();
    print $foo->getDescr();

The module can also query the Web interface to gather additional
information via the Ajax interface of the RIPE RIS dashboard. The
main use is to gather the list of announced prefixes for an ASN.

    use Net::Whois::RIS;

    my $foo = Net::Whois::RIS->new();
    $foo->getASNInfo("12684");
    print $foo->getPrefixes();

The module's first objective was to provide an easy IP to ASN
mapping interface via Perl.

For more information about the RIPE Routing Information Service :

http://www.ripe.net/ris/
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/N*
%perl_vendor_privlib/auto/*

%changelog
