# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Coro.pm) perl(Coro/AnyEvent.pm) perl(Coro/LWP.pm) perl(Coro/Socket.pm) perl(Coro/Timer.pm) perl(DBI.pm) perl(File/Slurp.pm) perl(Pod/Wordlist.pm) perl(Template.pm) perl(Test/Spelling.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Net-Whois-Raw
%define upstream_version 2.99040

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Get Whois information for domains
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Net/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(HTTP/Headers.pm)
BuildRequires: perl(HTTP/Request.pm)
BuildRequires: perl(IO/Socket/IP.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(Net/IDN/Punycode.pm)
BuildRequires: perl(Regexp/IPv6.pm)
BuildRequires: perl(Socket.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/RequiresInternet.pm)
BuildRequires: perl(URI/URL.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch

%global __requires_exclude perl\\(Win32API::Registry\\)
Source44: import.info
%description
Net::Whois::Raw queries WHOIS servers about domains. The module supports
recursive WHOIS queries. Also queries via HTTP is supported for some TLDs.

Setting the variables $OMIT_MSG and $CHECK_FAIL will match the results
against a set of known patterns. The first flag will try to omit the
copyright message/disclaimer, the second will attempt to determine if the
search failed and return undef in such a case.

*IMPORTANT*: these checks merely use pattern matching; they will work on
several servers but certainly not on all of them.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build CFLAGS="%{optflags}"

# Cancelling tests because they require external network to be accessed.
# %%check
# %make test

%install
%makeinstall_std

%files
%doc COPYRIGHT Changes LICENSE META.json META.yml  README
%{_bindir}/pwhois
%{_mandir}/man1/*
%{perl_vendor_privlib}/*

%changelog
