# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper.pm) perl(Exception/Class.pm) perl(HTML/Entities.pm) perl(HTTP/Request/Common.pm) perl(LWP/Protocol/http10.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Net/Z3950/SimpleServer.pm) perl(Net/Z3950/ZOOM.pm) perl(SOAP/Lite.pm) perl(XML/LibXML.pm) perl(XML/LibXML/XPathContext.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define module_name Net-Z3950-UDDI
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Perl extension for querying UDDI services using Z39.50
Group: Development/Perl
License: GPL-2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MIRK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This library provides all the guts of the Z39.50-to-UDDI gateway,
`z2uddi' (which is supplied along with it).  In the same package
comes an underlying library, `UDDI::HalfDecent', which supports a
subset of UDDI but supports it really well, reliably, and with good
error-reporting -- unlike, to pick the module-name out of the thin
air, `UDDI::Lite' for example.  Also included in the package are the
swarm of auxiliary modules which `UDDI::HalfDecent' and
`Net::Z3950::UDDI' use, and `uddihd', a simple command-line
test-harness to exercise the UDDI::HalfDecent library.

The gateway provides a server that understands not only ANSI/NISO
Z39.50 (aka. ISO 23950), but also the related web-service protocols
SRU (in both its GET and POST forms) and SRW (SRU over SOAP).

The API of the `Net::Z3950::UDDI' module itself is trivial: the
synopsis above captures it in its entirely, and is essentially the
whole of the code of the `z2uddi' script.  I'll document it anyway,
but the important stuff is elsewhere (see below).

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README GPL-2 Changes
%perl_vendor_privlib/N*
%perl_vendor_privlib/U*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
