%define module_name NewsExtractor
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Encode.pm) perl(File/Slurp.pm) perl(HTML/ExtractContent.pm) perl(HTTP/Date.pm) perl(IO/Socket/SSL.pm) perl(Importer.pm) perl(JSON.pm) perl(Module/Build/Tiny.pm) perl(Mojolicious.pm) perl(Moo.pm) perl(Ref/Util.pm) perl(SemanticWeb/Schema.pm) perl(Test2/V0.pm) perl(Try/Tiny.pm) perl(Type/Tiny.pm) perl(Types/URI.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.45.0
Release: alt1
Summary: download and extract news articles from Internet.
Group: Development/Perl
License: unrestricted
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUGOD/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
my ($error, $article) = NewsExtractor->new( url => $url )->download->parse;
    die $error if $error;

    # $article is an instance of NewsExtractor::Article
    say "Headline: " . $article->headline;
    say "When: " . ($article->dateline // "(unknown)");
    say "By: " . ($article->journalist // "(unknown)");
    say "\n" . $article->content_text;

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/N*

%changelog
