# BEGIN SourceDeps(oneline):
BuildRequires: perl(Eval/TypeTiny.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Sub/HandlesVia.pm) perl(Sub/Util.pm) perl(Test2/Require/AuthorTesting.pm) perl(Test2/Require/Module.pm) perl(Test2/Tools/Spec.pm) perl(Test2/V0.pm) perl(Type/Registry.pm) perl(Type/Tiny/Class.pm) perl(Types/Common.pm) perl(namespace/autoclean.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Newtype
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Perl implementation of an approximation for Haskell's newtype
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Newtype

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module allows you to create a new type which is a subclass of an existing
type.

Why?

Well maybe you want to add some new methods to the new type:

  use HTTP::Tiny ();
  use Newtype HttpTiny => {
    inner => 'HTTP::Tiny',
    methods => {
      'post_or_get' => sub {
        my $self = shift;
        my $res = $self->post( @_ );
        return $res if $res->{success};
        return $self->get( @_ );
      },
  };

Or maybe you need to differentiate between two different kinds of things
which are otherwise the same class.

  use Newtype (
    SecureUA    => { inner => 'HTTP::Tiny' },
    InsecureUA  => { inner => 'HTTP::Tiny' },
  );
  
  ...;
  
  my $ua = InsecureUA( HTTP::Tiny->new );
  
  ...;
  
  if ( $ua->isa(SecureUA) ) {
    ...;
  }

Newtype can also create new types which "inherit" from Perl builtins.

  use Types::Common qw( ArrayRef PositiveInt );
  use Newtype Numbers => { inner => ArrayRef[PositiveInt] };
  
  my $nums = Numbers( [] );
  $nums->push(  1 );
  $nums->push(  2 );
  $nums->push( -1 );  # dies

See the Hydrogen manpage for the list of available methods for builtins.

Newtypes which inherit from builtins use overloading to attempt to provide
transparency.

Although there will be exceptions to this general rule of thumb (especially
if your newtype is inheriting from a Perl builtin), you can think of things
like this: if you create a type NewFoo from existing type Foo, then
instances of NewFoo should be accepted everywhere instances of Foo are.
But instances of Foo will not be automatically accepted where instances of
NewFoo are.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE CREDITS COPYRIGHT README
%perl_vendor_privlib/N*

%changelog
