# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(GD/Graph.pm) perl(GD/Graph/bars.pm) perl(GD/Graph/hbars.pm) perl(GD/Graph/pie.pm) perl(Net/DNS.pm) perl(Net/LDAP.pm) perl(Net/NNTP.pm) perl(Network/IPv4Addr.pm) perl(Test.pm) perl(Text/BarGraph.pm) perl(Text/Diff.pm) perl(XML/SAX/Base.pm) perl(XML/Simple.pm) perl(threads.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Nmap-Scanner
%define upstream_version 1.0

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_13

Summary:    Perform and manipulate nmap scans using perl
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Nmap/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Class/Generate.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(LWP/UserAgent.pm)
BuildRequires: perl(XML/SAX.pm)
Provides: perl(Nmap/Scanner/Address.pm)  
Provides: perl(Nmap/Scanner/Distance.pm)  
Provides: perl(Nmap/Scanner/ExtraPorts.pm)  
Provides: perl(Nmap/Scanner/Host.pm)  
Provides: perl(Nmap/Scanner/Hostname.pm)  
Provides: perl(Nmap/Scanner/Hosts.pm)  
Provides: perl(Nmap/Scanner/NmapRun.pm)  
Provides: perl(Nmap/Scanner/OS.pm)  
Provides: perl(Nmap/Scanner/OS/Class.pm)  
Provides: perl(Nmap/Scanner/OS/Fingerprint.pm)  
Provides: perl(Nmap/Scanner/OS/IPIdSequence.pm)  
Provides: perl(Nmap/Scanner/OS/Match.pm)  
Provides: perl(Nmap/Scanner/OS/PortUsed.pm)  
Provides: perl(Nmap/Scanner/OS/TCPSequence.pm)  
Provides: perl(Nmap/Scanner/OS/TCPTSSequence.pm)  
Provides: perl(Nmap/Scanner/OS/Uptime.pm)  
Provides: perl(Nmap/Scanner/Port.pm)  
Provides: perl(Nmap/Scanner/RunStats.pm)  
Provides: perl(Nmap/Scanner/RunStats/Finished.pm)  
Provides: perl(Nmap/Scanner/ScanInfo.pm)  
Provides: perl(Nmap/Scanner/Service.pm)  
Provides: perl(Nmap/Scanner/Task.pm)  
Provides: perl(Nmap/Scanner/TaskProgress.pm)  
Requires: nmap
BuildArch: noarch
Source44: import.info


%description
This set of modules provides perl class wrappers for the network mapper
(nmap) scanning tool (see http://www.insecure.org/nmap/). Using these
modules, a developer, network administrator, or other techie can create
perl routines or classes which can be used to automate and integrate nmap
scans elegantly into new and existing perl scripts.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
# (tv) disable tests that need networking:
rm -f t/event_tcp_syn_scan_from_file.t 
%make_build test

%install
%makeinstall_std

%files
%doc Changes README
%perl_vendor_privlib/*


%changelog
