%define module_name NumSeq-Iter
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.008
Release: alt1
Summary: Generate a coderef iterator from a number sequence specification (e.g. '1,3,5,...,101')
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/NumSeq-Iter

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a simple (coderef) iterator which you can call repeatedly
to get numbers specified in a number sequence specification (string). When the
numbers are exhausted, the coderef will return undef. No class/object involved.

A number sequence is a comma-separated list of numbers (either integer like 1,
-2 or decimal number like 1.3, -100.70) with at least one number. It can contain
an ellipsis (e.g. '1,2,3,...' or '1, 3, 5, ..., 10').

When the sequence has an ellipsis, there must be at least three numbers before
the ellipsis. There can optionally be another number after the ellipsis to make
the sequence finite; but the last number can also be Inf, +Inf, or -Inf.
Currently only simple arithmetic sequence ('1,3,5') or simple geometric sequence
('2,6,18') is recognized.

=for Pod::Coverage .+

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/N*

%changelog
