%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires(pre): perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1_1
%define module_name Number-Phone-DE-Mobile
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1_1
Release: alt1
Summary: >checkmsisdn($rawmsisdn);
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NE/NETSRAK/%module_name-%module_version.tgz
BuildArch: noarch

%description
Number::Phone::DE::Mobile is a simple module to validate German Mobile Phone Numbers
(MSISDNs) and return them in a single format.

regarding the fact, that mobile phone msisdns can contain 7 or 8 digits
behind the area code and also regarding the various msisdn-output formats
on wap gateways, sms-servers etc. i wrote a small perl-module
that transforms all msisdns, no matter what input-format you use, into
one, standard output format:

                        xxyyyzzzzzzzz
where:
x = country code
y = area code
z = subscriber number (either 7 or 8 digits...)

basically there are 10 types of msisdn-notations that are possible at
present and that are supported by the module:
7-digit numbers:

0049___17x_____1234567_____=14 digits

34_____17x_____1234567_____=12 digits

00_____17x_____1234567_____=12 digits

0______17x_____1234567_____=11 digits

_______17x_____1234567_____=10 digits



8-digit numbers:

0049___17x_____12345678____=15 digits

34_____17x_____12345678____=13 digits

00_____17x_____12345678____=13 digits

0______17x_____12345678____=12 digits

_______17x_____12345678____=11 digits


comments:
1) the country code can be any number not starting with a zero.
(this will work for nearly all countries except countries with a 
single digit country code.)

2) the area code can be any 3-digit number starting with
"1" (i.e.: 179, 176, 150, 160, 168 etc...)

3) a leading "+" sign will be translated into two zeros "00"
before its processed

4) special characters like "+","&",";","_","-","." will be deleted from the
msisdn before its processed

5) if the msisdn is not ok, the program returns "invalid".

=over 8


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README example
%perl_vendor_privlib/N*

%changelog
