# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Mouse.pm) perl(Pod/Markdown.pm) perl(Scalar/Util.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.6.1
%define module_name Number-RangeTracker
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.6.1
Release: alt1
Summary: Keep track of numerical ranges quickly
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CO/COVINGTON/%{module_name}-v%{module_version}.tar.gz
BuildArch: noarch

%description
An instance of the Number::RangeTracker class is used to keep track of
a set of numerical ranges. Ranges can be added to and removed from
this collection of ranges. Overlapping ranges are collapsed to form a
single, longer range. Ranges can be manipulated, examined, and output
in a variety of ways.

While some other modules associate values with a range of keys (see
the SEE ALSO entry elsewhere in this document), the objective of Number::RangeTracker is to quickly and
easily monitor the integers on a number line that are covered by at
least one range. Number::RangeTracker performs significantly faster
than other modules that have similar functions (see the SEE ALSO entry elsewhere in this document).

=over 4

=item new

Initializes a new Number::RangeTracker object.
%prep
%setup -n %{module_name}-v%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md CHANGES
%perl_vendor_privlib/N*

%changelog
