%define module_name Nuvol
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Mojo/File/Role/Digest.pm) perl(Mojolicious.pm) perl(Print/Colored.pm) perl(Role/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: A cloud toolkit
Group: Development/Perl
License: artistic_2
URL: https://github.com/Tekki/nuvol

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TE/TEKKI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the Nuvol manpage is a toolkit to manipulate files and folders on cloud services. For the beginning it
supports Dropbox, Office 365, and a Dummy service.

    Nuvol
    .ii.ie.ie Connector
        .i'.ie.ie Config
        .i'   .ii.ie.ie config file
        .ii.ie.ie Drive
            .ii.ie.ie Item
                .i'.ie.ie File
                .ii.ie.ie Folder

The services are organized in connectors, drives, items, files, and folders. The data needed to
access a service is stored in a config file.

=over 4

=item Connector

The Connector is responsible for authentication and for the connection to the
cloud service.

=item Config and config file

The config file stores the tokens and other parameters used to establish a connection. Internally is
is represented by a Config object.

Warning: The information in the config file allows full access to your cloud data for anyone who
can read it. It should be stored at a secure place. Services that are no longer used should be
disabled with the disconnect entry in the Nuvol::Connector manpage.

=item Drive

A Drive is an isolated area where your data is stored. You may have a drive for your
personal and another for your business data. Not all cloud providers support different drives.

=item Item

Every object in a drive is an Item. Item is just an abstract type, a real object is
either a File or a Folder.

The syntax for drive items is oriented at the Mojo::File manpage, so anyone familiar with this module will
recognize most of the methods.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/N*

%changelog
