%define module_name ODF-lpOD_Helper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(Carp.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Data/Dumper/Interp.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(English.pm) perl(Env.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(Guard.pm) perl(Import/Into.pm) perl(List/Util.pm) perl(ODF/lpOD.pm) perl(POSIX.pm) perl(Path/Tiny.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test2/Plugin/BailOnFail.pm) perl(Test2/V0.pm) perl(Time/HiRes.pm) perl(autovivification.pm) perl(bytes.pm) perl(constant.pm) perl(feature.pm) perl(indirect.pm) perl(lib.pm)
BuildRequires: perl(multidimensional.pm) perl(open.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 5.012
Release: alt1
Summary: ease-of-use wrapper for ODF::lpOD
Group: Development/Perl
License: unrestricted
URL: https://github.com/jimav/ODF-lpOD_Helper

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JI/JIMAVERA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
ODF::lpOD_Helper provides higher-level Unicode-enabled search and replace
(or insert) of text which may span segments, may contain newlines, 
tabs, or multiple spaces, using ordinary Perl character strings.

Styles may be specified with a high-level notation and
the necessary ODF styles are automatically managed and fonts registered.

ODF::lpOD by itself is not convenient for text operations because

=over

=item 1.

`ODF::lpOD' requires text to be passed as encoded binary octets,
rather than as Perl characters (see 'man perlunicode').

=item 2.

*Search* can not match strings which span segments, such as
those created automatically by LibreOffice to support
it's "record changes" function.

=item 3.

*Search* can not match strings containing newlines, tabs, or repeated spaces,
nor can those things be easily inseted.

=back

`ODF::lpOD_Helper'
also works around a bug causing "Unknown_method_DESTROY" warnings
(see https://rt.cpan.org/Public/Bug/Display.html?id=97977)

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README LICENSE.txt
%perl_vendor_privlib/O*

%changelog
