%define module_name OIDC-Client
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Crypt/JWT.pm) perl(Data/UUID.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/MoreUtils.pm) perl(List/Util.pm) perl(Log/Any.pm) perl(Log/Any/Test.pm) perl(Module/Load.pm) perl(Mojolicious.pm) perl(Moose.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Params/Validate.pm) perl(Readonly.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/MockModule.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(Test/Warn.pm) perl(Throwable/Error.pm) perl(Try/Tiny.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.04
Release: alt1
Summary: OpenID Connect Client
Group: Development/Perl
License: artistic_2
URL: https://github.com/sebmourlhou/oidc-client

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SM/SMOURLHOU/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Client module for OpenID Connect protocol.

Use this module directly from a batch or a simple script. For use from within
an application, you should instead use the framework plugin :

=over 2

=item Mojolicious

the Mojolicious::Plugin::OIDC manpage

=item Catalyst

the Catalyst::Plugin::OIDC manpage

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/O*

%changelog
