%define module_name OPM-Maker
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/Cmd.pm) perl(Capture/Tiny.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Find/Rule.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(Getopt/Long.pm) perl(HTTP/Tiny.pm) perl(JSON/PP.pm) perl(MIME/Base64.pm) perl(OPM/Validate.pm) perl(Path/Class.pm) perl(Pod/Coverage/TrustPod.pm) perl(Sys/Hostname.pm) perl(Test/LongString.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/Gitignore.pm) perl(XML/LibXML.pm) perl(XML/LibXML/PrettyPrint.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.17
Release: alt1
Summary: Module/App to build and test OPM packages for Znuny, OTOBO, ((OTRS)) Community edition.
Group: Development/Perl
License: artistic_2
URL: https://github.com/reneeb/OPM-Maker

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLSRVDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
If you do customizing for ticketing systems like Znuny, OTOBO or ((OTRS)) Community Edition, you need to be able to check your package: Are all files of the package included in the file list in the sopm file? Is the sopm file valid? And you need to create the OPM file. There is otrs.PackageManager.pl included in OTRS installations, but sometimes you might not have an OTRS installation on the machine where you want to build the package (e.g. when you build the package in a Jenkins job).

`OPM::Maker' provides `opmbuild' that is a small tool for several tasks. At the moment it supports:

=over 4

=item * filetest

Check if all files in the filelist exist on your disk and if all files on the disk are listed in the filelist

=item * somptest

Checks if your .sopm file is valid

=item * dependencies

List all CPAN- and ticket system - dependencies of your package

=item * build

Create the OPM file

=item * index

build an index file for an OPM repository.

=back

Currently under development:

=over 4

=item * dbtest

Check if the `DatabaseInstall' and `DatabaseUninstall' sections in your .sopm files are valid. And it checks for SQL keywords.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTORS Changes LICENSE README CONTRIBUTING.md
%perl_vendor_privlib/O*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
