Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(DBD/SQLite.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-ORLite-Mirror
Version:        1.24
Release:        alt2_37
Summary:        Extend ORLite to support remote SQLite databases
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/ORLite-Mirror
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/ORLite-Mirror-%{version}.tar.gz
# Update Makefile.PL to not use Module::Install::DSL CPAN RT#148299
Patch0:         ORLite-Mirror-1.24-Remove-using-of-MI-DSL.patch
BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/Share.pm)
BuildRequires:  perl(Module/Install/With.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/HomeDir.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Remove.pm)
BuildRequires:  perl(File/ShareDir.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(IO/Uncompress/Bunzip2.pm)
BuildRequires:  perl(IO/Uncompress/Gunzip.pm)
BuildRequires:  perl(LWP/Online.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(ORLite.pm)
BuildRequires:  perl(Params/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
# Tests
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(IO/Compress/Bzip2.pm)
BuildRequires:  perl(IO/Compress/Gzip.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(URI/file.pm)
Requires:       perl(IO/Uncompress/Bunzip2.pm) >= 2.008
Requires:       perl(IO/Uncompress/Gunzip.pm) >= 2.008


Source44: import.info

%description
ORLite provides a read-only ORM API when it loads a read-only SQLite database
from your local system. By combining this capability with LWP, ORLite::Mirror
goes one step better and allows you to load a SQLite database from any
arbitrary URI in read-only form as well.

%prep
%setup -q -n ORLite-Mirror-%{version}
%patch0  -p1
# Remove bundled libraries
rm -r inc
perl -i -ne 'print $_ unless m{^inc/}' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
find $RPM_BUILD_ROOT -type f -name stub.db -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/auto*
%{perl_vendor_privlib}/ORLite*

%changelog
