Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-ORLite-Statistics
Version:        0.03
Release:        alt2_42
Summary:        Statistics enhancement package for ORLite
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/ORLite-Statistics
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/ORLite-Statistics-%{version}.tar.gz
# Update Makefile.PL to not use Module::Install::DSL CPAN RT#148300
Patch0:         ORLite-Statistics-0.03-Remove-using-of-MI-DSL.patch
BuildArch:      noarch
# Build
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
# Runtime
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ORLite.pm)
BuildRequires:  perl(Statistics/Basic.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Tests only
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
This is an enhancement module for ORLite table classes, designed to provide
easy integration with the Statistics::Base module.

%prep
%setup -q -n ORLite-Statistics-%{version}
%patch0  -p1
# Remove bundled modules
rm -r ./inc/*
perl -i -ne 'print $_ unless m{^inc/}' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*

%check
unset AUTOMATED_TESTING RELEASE_TESTING
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/ORLite*

%changelog
