# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Digest/MD5.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.03
%define module_name Object-FromData
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Throw arrayrefs or hashrefs at this to get an object
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/O/OV/OVID/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
use Object::FromData;

    my $object = Object::FromData->new(
        {   ref => {
                foo      => 'bar',
                this     => 'that',
                _private => 'no method will be created',
                colors   => [qw/red blue green/],
                numbers  => {
                    un    => 1,
                    deux  => 2,
                    trois => 3,
                },
            },
        }
    );

    say $object->is_hashref;     # 1
    say $object->is_arrayref;    # 0

    say $object->foo;            # bar
    say $object->this;           # that
    say $object->_private;       # BOOM! No such method

    say $object->numbers->is_hashref;     # 0
    say $object->numbers->is_arrayref;    # 1
    say $object->numbers->deux;           # 2

    my $colors = $object->colors;
    while ( $colors->has_more ) {
        say $colors->next;    # red, blue, green on successive lines
    }


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/O*

%changelog
